<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="mb-0">
        <i class="bi bi-mortarboard me-2"></i>Kelola Riwayat Pendidikan
    </h2>
    <a href="<?= base_url('admin/education/create') ?>" class="btn btn-primary">
        <i class="bi bi-plus-circle me-1"></i>Tambah Pendidikan
    </a>
</div>

<?php if (session()->getFlashdata('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="bi bi-check-circle me-2"></i><?= session()->getFlashdata('success') ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if (session()->getFlashdata('error')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="bi bi-exclamation-triangle me-2"></i><?= session()->getFlashdata('error') ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<!-- Search and Filter Section -->
<div class="admin-card">
    <form method="GET" action="<?= base_url('admin/education') ?>" class="row g-3">
        <div class="col-md-3">
            <label for="search" class="form-label">Cari Pendidikan</label>
            <input type="text" class="form-control" id="search" name="search" 
                   value="<?= esc($search) ?>" placeholder="Cari sekolah, jurusan...">
        </div>
        <div class="col-md-2">
            <label for="jenjang" class="form-label">Jenjang</label>
            <select class="form-select" id="jenjang" name="jenjang">
                <option value="">Semua</option>
                <option value="SD" <?= $filter['jenjang'] === 'SD' ? 'selected' : '' ?>>SD</option>
                <option value="SMP" <?= $filter['jenjang'] === 'SMP' ? 'selected' : '' ?>>SMP</option>
                <option value="SMA" <?= $filter['jenjang'] === 'SMA' ? 'selected' : '' ?>>SMA</option>
                <option value="SMK" <?= $filter['jenjang'] === 'SMK' ? 'selected' : '' ?>>SMK</option>
                <option value="D3" <?= $filter['jenjang'] === 'D3' ? 'selected' : '' ?>>D3</option>
                <option value="S1" <?= $filter['jenjang'] === 'S1' ? 'selected' : '' ?>>S1</option>
                <option value="S2" <?= $filter['jenjang'] === 'S2' ? 'selected' : '' ?>>S2</option>
                <option value="S3" <?= $filter['jenjang'] === 'S3' ? 'selected' : '' ?>>S3</option>
            </select>
        </div>
        <div class="col-md-2">
            <label for="status_pendidikan" class="form-label">Status</label>
            <select class="form-select" id="status_pendidikan" name="status_pendidikan">
                <option value="">Semua Status</option>
                <option value="lulus" <?= ($filter['status_pendidikan'] ?? '') === 'lulus' ? 'selected' : '' ?>>Lulus</option>
                <option value="sedang_menempuh" <?= ($filter['status_pendidikan'] ?? '') === 'sedang_menempuh' ? 'selected' : '' ?>>Sedang Menempuh</option>
                <option value="tidak_lulus" <?= ($filter['status_pendidikan'] ?? '') === 'tidak_lulus' ? 'selected' : '' ?>>Tidak Lulus</option>
                <option value="cuti" <?= ($filter['status_pendidikan'] ?? '') === 'cuti' ? 'selected' : '' ?>>Cuti</option>
                <option value="pindah" <?= ($filter['status_pendidikan'] ?? '') === 'pindah' ? 'selected' : '' ?>>Pindah</option>
            </select>
        </div>
        <div class="col-md-2">
            <label for="tahun_mulai" class="form-label">Tahun Mulai</label>
            <input type="number" class="form-control" id="tahun_mulai" name="tahun_mulai" 
                   value="<?= esc($filter['tahun_mulai']) ?>" placeholder="Tahun mulai...">
        </div>
        <div class="col-md-2">
            <label for="tahun_selesai" class="form-label">Tahun Selesai</label>
            <input type="number" class="form-control" id="tahun_selesai" name="tahun_selesai" 
                   value="<?= esc($filter['tahun_selesai']) ?>" placeholder="Tahun selesai...">
        </div>
        <div class="col-md-2">
            <label for="sort" class="form-label">Sort By</label>
            <select class="form-select" id="sort" name="sort">
                <option value="urutan" <?= $sort === 'urutan' ? 'selected' : '' ?>>Urutan</option>
                <option value="jenjang" <?= $sort === 'jenjang' ? 'selected' : '' ?>>Jenjang</option>
                <option value="nama_sekolah" <?= $sort === 'nama_sekolah' ? 'selected' : '' ?>>Nama Sekolah</option>
                <option value="tahun_mulai" <?= $sort === 'tahun_mulai' ? 'selected' : '' ?>>Tahun Mulai</option>
                <option value="tahun_selesai" <?= $sort === 'tahun_selesai' ? 'selected' : '' ?>>Tahun Selesai</option>
                <option value="status_pendidikan" <?= $sort === 'status_pendidikan' ? 'selected' : '' ?>>Status</option>
                <option value="nilai_akhir" <?= $sort === 'nilai_akhir' ? 'selected' : '' ?>>Nilai Akhir</option>
            </select>
        </div>
        <div class="col-md-1">
            <label for="order" class="form-label">Order</label>
            <select class="form-select" id="order" name="order">
                <option value="ASC" <?= $order === 'ASC' ? 'selected' : '' ?>>ASC</option>
                <option value="DESC" <?= $order === 'DESC' ? 'selected' : '' ?>>DESC</option>
            </select>
        </div>
        <div class="col-md-12 d-flex align-items-end">
            <button type="submit" class="btn btn-primary">
                <i class="bi bi-funnel me-1"></i>Filter
            </button>
        </div>
    </form>
</div>

<!-- Education Table -->
<div class="admin-card">
    <?php if (empty($education)): ?>
        <div class="alert alert-info text-center">
            <i class="bi bi-info-circle me-2"></i>Tidak ada riwayat pendidikan yang ditemukan.
        </div>
    <?php else: ?>
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>
                            <a href="<?= base_url('admin/education?sort=urutan&order=' . ($sort === 'urutan' && $order === 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search)) ?>" 
                               class="text-white text-decoration-none">
                                Urutan <i class="bi bi-arrow-down-up"></i>
                            </a>
                        </th>
                        <th>
                            <a href="<?= base_url('admin/education?sort=jenjang&order=' . ($sort === 'jenjang' && $order === 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search)) ?>" 
                               class="text-white text-decoration-none">
                                Jenjang <i class="bi bi-arrow-down-up"></i>
                            </a>
                        </th>
                        <th>
                            <a href="<?= base_url('admin/education?sort=nama_sekolah&order=' . ($sort === 'nama_sekolah' && $order === 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search)) ?>" 
                               class="text-white text-decoration-none">
                                Nama Sekolah <i class="bi bi-arrow-down-up"></i>
                            </a>
                        </th>
                        <th>Jurusan</th>
                        <th>
                            <a href="<?= base_url('admin/education?sort=tahun_mulai&order=' . ($sort === 'tahun_mulai' && $order === 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search)) ?>" 
                               class="text-white text-decoration-none">
                                Tahun <i class="bi bi-arrow-down-up"></i>
                            </a>
                        </th>
                        <th>
                            <a href="<?= base_url('admin/education?sort=status_pendidikan&order=' . ($sort === 'status_pendidikan' && $order === 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search)) ?>" 
                               class="text-white text-decoration-none">
                                Status <i class="bi bi-arrow-down-up"></i>
                            </a>
                        </th>
                        <th>
                            <a href="<?= base_url('admin/education?sort=nilai_akhir&order=' . ($sort === 'nilai_akhir' && $order === 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search)) ?>" 
                               class="text-white text-decoration-none">
                                Nilai <i class="bi bi-arrow-down-up"></i>
                            </a>
                        </th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $no = ($pager->getCurrentPage() - 1) * 10 + 1; ?>
                    <?php foreach ($education as $edu): ?>
                        <tr>
                            <td><?= $no++ ?></td>
                            <td><?= esc($edu['urutan']) ?></td>
                            <td><span class="badge bg-primary"><?= esc($edu['jenjang']) ?></span></td>
                            <td><?= esc($edu['nama_sekolah']) ?></td>
                            <td><?= esc($edu['jurusan'] ?? '-') ?></td>
                            <td>
                                <?php if ($edu['tahun_mulai'] && $edu['tahun_selesai']): ?>
                                    <?= esc($edu['tahun_mulai']) ?> - <?= esc($edu['tahun_selesai']) ?>
                                <?php elseif ($edu['tahun_mulai']): ?>
                                    <?= esc($edu['tahun_mulai']) ?> - <?= ($edu['status_pendidikan'] ?? 'lulus') === 'sedang_menempuh' ? 'Sekarang' : '-' ?>
                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php 
                                $status = $edu['status_pendidikan'] ?? 'lulus';
                                $statusClass = [
                                    'lulus' => 'bg-success',
                                    'sedang_menempuh' => 'bg-primary',
                                    'tidak_lulus' => 'bg-danger',
                                    'cuti' => 'bg-warning',
                                    'pindah' => 'bg-info'
                                ];
                                $statusText = [
                                    'lulus' => 'Lulus',
                                    'sedang_menempuh' => 'Sedang Menempuh',
                                    'tidak_lulus' => 'Tidak Lulus',
                                    'cuti' => 'Cuti',
                                    'pindah' => 'Pindah'
                                ];
                                ?>
                                <span class="badge <?= $statusClass[$status] ?? 'bg-secondary' ?>">
                                    <?= $statusText[$status] ?? 'Unknown' ?>
                                </span>
                            </td>
                            <td><?= esc($edu['nilai_akhir'] ?? '-') ?></td>
                            <td>
                                <a href="<?= base_url('admin/education/edit/' . $edu['id']) ?>" 
                                   class="btn btn-sm btn-warning btn-action">
                                    <i class="bi bi-pencil"></i>
                                </a>
                                <a href="<?= base_url('admin/education/delete/' . $edu['id']) ?>" 
                                   class="btn btn-sm btn-danger btn-action"
                                   onclick="return confirm('Yakin ingin menghapus riwayat pendidikan ini?')">
                                    <i class="bi bi-trash"></i>
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <?php if ($pager->hasMore() || $pager->getCurrentPage() > 1): ?>
            <nav aria-label="Page navigation">
                <ul class="pagination">
                    <?php if ($pager->hasPrevious()): ?>
                        <li class="page-item">
                            <a class="page-link" href="<?= $pager->getPreviousPageURI() ?>">
                                <i class="bi bi-chevron-left"></i>
                            </a>
                        </li>
                    <?php endif; ?>
                    
                    <?php for ($i = 1; $i <= $pager->getLastPage(); $i++): ?>
                        <li class="page-item <?= $i == $pager->getCurrentPage() ? 'active' : '' ?>">
                            <a class="page-link" href="<?= base_url('admin/education?page=' . $i . '&search=' . urlencode($search) . '&jenjang=' . urlencode($filter['jenjang']) . '&tahun_mulai=' . urlencode($filter['tahun_mulai']) . '&tahun_selesai=' . urlencode($filter['tahun_selesai']) . '&status_pendidikan=' . urlencode($filter['status_pendidikan'] ?? '') . '&sort=' . $sort . '&order=' . $order) ?>">
                                <?= $i ?>
                            </a>
                        </li>
                    <?php endfor; ?>
                    
                    <?php if ($pager->hasMore()): ?>
                        <li class="page-item">
                            <a class="page-link" href="<?= $pager->getNextPageURI() ?>">
                                <i class="bi bi-chevron-right"></i>
                            </a>
                        </li>
                    <?php endif; ?>
                </ul>
            </nav>
        <?php endif; ?>
    <?php endif; ?>
</div>
<?= $this->endSection() ?>


